
from gurobipy import *

# Create a model
m = Model("FastFoodOptimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Cheeseburgers")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Fries")

# Set objective function: Maximize profit
m.setObjective(1.50*x1 + 1.00*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 110, "Demand_Cheeseburgers")
m.addConstr(x2 <= 80, "Demand_Fries")
m.addConstr(x1 + x2 <= 150, "Total_Capacity")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Produce {x1.x} cheeseburgers")
    print(f"Produce {x2.x} fries")
    print(f"Maximum Profit: ${m.objVal}")
else:
    print("No optimal solution found")

