
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="x1")  # Number of cheeseburgers
    x2 = model.addVar(lb=0, name="x2")  # Number of fries

    # Objective function: Maximize profit
    model.setObjective(1.50 * x1 + x2, gurobi.GRB.MAXIMIZE)

    # Demand constraints
    model.addConstr(x1 <= 110, name="cheeseburger_demand")
    model.addConstr(x2 <= 80, name="fries_demand")

    # Capacity constraint
    model.addConstr(x1 + x2 <= 150, name="production_capacity")

    # Optimize
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Cheeseburgers (x1): {x1.varValue}")
        print(f"Fries (x2): {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
