
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("furniture_optimization")

# Create decision variables
s = m.addVar(vtype=GRB.CONTINUOUS, name="sofas")
b = m.addVar(vtype=GRB.CONTINUOUS, name="beds")

# Set objective function
m.setObjective(100 * s + 200 * b, GRB.MAXIMIZE)

# Add constraints
m.addConstr(8 * s + 12 * b <= 500, "space_constraint")
m.addConstr(200 * s + 300 * b <= 12500, "budget_constraint")
m.addConstr(s >= 0.3 * (s + b), "sofa_proportion_constraint")
m.addConstr(s >= 0, "non_negativity_s")
m.addConstr(b >= 0, "non_negativity_b")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of sofas: {s.x:.2f}")
    print(f"Number of beds: {b.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

