
from gurobipy import *

# Create a new model
m = Model("Outlet Optimization")

# Define the decision variables
x = m.addVar(name="sofas", vtype=GRB.INTEGER, lb=0)
y = m.addVar(name="beds", vtype=GRB.INTEGER, lb=0)

# Define the objective function: Maximize profit
m.setObjective(100*x + 200*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(8*x + 12*y <= 500, name="space_constraint")
m.addConstr(200*x + 300*y <= 12500, name="budget_constraint")
m.addConstr(x >= 0.3*(x + y), name="sofa_percentage_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of sofas: {x.x}")
    print(f"Number of beds: {y.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found. The model is infeasible.")

