
import gurobipy as gp

# Create a new model
m = gp.Model("SofaBedProblem")

# Variables
S_b = m.addVar(name="Sofa_Buy", vtype=gp.GRB.INTEGER, lb=0)
B_b = m.addVar(name="Bed_Buy", vtype=gp.GRB.INTEGER, lb=0)

# Objective function: Maximize profit
m.setObjective(100 * S_b + 200 * B_b, gp.GRB.MAXIMIZE)

# Space constraint
m.addConstr(8 * S_b + 12 * B_b <= 500, name="Space_Constraint")

# Budget constraint
m.addConstr(200 * S_b + 300 * B_b <= 12500, name="Budget_Constraint")

# Sofa percentage constraint
m.addConstr(7 * S_b >= 3 * B_b, name="Sofa_Percentage_Constraint")

# Solve the model
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution: Buy {S_b.varValue} sofas and {B_b.varValue} beds")
else:
    print("The problem is infeasible")
