
import gurobipy as gp

# Create a new model
m = gp.Model("Investment_Problem")

# Create variables
x = m.addVar(name="younger_sister_investment")
y = m.addVar(name="elder_sister_investment")

# Set objective function
m.setObjective(0.05 * x + 0.08 * y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 5000, "total_investment")
m.addConstr(x >= 2000, "min_younger_sister")
m.addConstr(y >= 2000, "min_elder_sister")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal investment in younger sister's company: {x.x}")
    print(f"Optimal investment in elder sister's company: {y.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("Problem is infeasible or unbounded.")

