
from gurobipy import *

# Create a model
m = Model("Investment_Optimization")

# Define variables
x_y = m.addVar(name='younger_sister_investment', lb=0)  # Investment in younger sister's company
x_e = m.addVar(name='elder_sister_investment', lb=0)    # Investment in elder sister's company

# Objective function: Maximize profit
m.setObjective(0.05*x_y + 0.08*x_e, GRB.MAXIMIZE)

# Constraints
m.addConstr(x_y + x_e <= 5000, name='total_investment')         # Total investment is $5000
m.addConstr(x_y >= 0.4 * 5000, name='minimum_younger_sister')   # At least 40% of $5000 in younger sister's company
m.addConstr(x_e >= 2000, name='minimum_elder_sister')           # At least $2000 in elder sister's company

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal investment in younger sister's company: ${x_y.x}")
    print(f"Optimal investment in elder sister's company: ${x_e.x}")
    print(f"Maximum profit: ${m.objVal}")
else:
    print("No optimal solution found")
