
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    Y = model.addVar(lb=0, name="Younger_Sister_Investment")
    E = model.addVar(lb=0, name="Elder_Sister_Investment")

    # Objective function: Maximize profit
    model.setObjective(0.05 * Y + 0.08 * E, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(Y + E <= 5000, name="Total_Investment")
    model.addConstr(Y >= 2000, name="Minimum_Y_Investment")
    model.addConstr(E >= 2000, name="Minimum_E_Investment")

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal investment in younger sister's company: ${Y.varValue:.2f}")
        print(f"Optimal investment in elder sister's company: ${E.varValue:.2f}")
        print(f"Maximum profit: ${0.05 * Y.varValue + 0.08 * E.varValue:.2f}")
    else:
        print("No optimal solution found.")

solve_investment_problem()
