
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("IND_Foods")

# Create variables
x = m.addVar(lb=0, name="basmati_rice") # Kilograms of basmati rice
y = m.addVar(lb=0, name="bananas") # Kilograms of bananas

# Set objective function
m.setObjective(15*x + 28*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.5*x + 2*y <= 90, "human_labor")
m.addConstr(2*x + 4*y <= 150, "machine_labor")
m.addConstr(3*x + 1.5*y <= 70, "sun_resting")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Basmati Rice (kg): {x.x}")
    print(f"Bananas (kg): {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

