
from gurobipy import *

# Create a new model
m = Model("IND_Foods")

# Define the decision variables
x = m.addVar(lb=0, name="basmati_rice")
y = m.addVar(lb=0, name="bananas")

# Set the objective function: maximize profit
m.setObjective(15*x + 28*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.5*x + 2*y <= 90, "human_labor")
m.addConstr(2*x + 4*y <= 150, "machine_work")
m.addConstr(3*x + 1.5*y <= 70, "time_under_sun")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Basmati Rice: {x.x} kg")
    print(f"Bananas: {y.x} kg")
    print(f"Total Profit: ${15*x.x + 28*y.x}")
else:
    print("No optimal solution found.")
