
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the decision variables
x = m.addVar(lb=0, name="basmati_rice")  # kilograms of basmati rice
y = m.addVar(lb=0, name="bananas")  # kilograms of bananas

# Define the objective function
m.setObjective(15 * x + 28 * y, gurobi.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(1.5 * x + 2 * y <= 90, name="human_labor")
m.addConstr(2 * x + 4 * y <= 150, name="machine_work")
m.addConstr(3 * x + 1.5 * y <= 70, name="resting_under_sun")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Basmati rice: {x.varValue} kg")
    print(f"Bananas: {y.varValue} kg")
    print(f"Max profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found.")
