
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("JewelryProduction")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="rings")
y = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="necklaces")

# Set objective function
model.setObjective(50*x + 75*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(x + 3*y <= 15, "heating_constraint")
model.addConstr(2*x + 4*y <= 12, "polishing_constraint")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Profit: ${model.objVal:.2f}")
    print(f"Number of Rings: {x.x:.2f}")
    print(f"Number of Necklaces: {y.x:.2f}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

