
from gurobipy import *

# Create a new model
m = Model("Production_Scheduling")

# Define the decision variables
R = m.addVar(vtype=GRB.INTEGER, name="Rings", lb=0)
N = m.addVar(vtype=GRB.INTEGER, name="Necklaces", lb=0)

# Set the objective function: Maximize profit
m.setObjective(50*R + 75*N, GRB.MAXIMIZE)

# Add constraints
m.addConstr(R + 3*N <= 15, "Heating_Machine_Constraint")
m.addConstr(2*R + 4*N <= 12, "Polishing_Machine_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of Rings: {R.x}")
    print(f"Number of Necklaces: {N.x}")
    print(f"Total Profit: ${50*R.x + 75*N.x:.2f}")
else:
    print("No optimal solution found")
