
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("sauce_production")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pasta_sauce")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bbq_sauce")

# Set objective function
m.setObjective(3*x + 5*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + 3*y <= 12500, "filling_constraint")
m.addConstr(3*x + 4*y <= 20000, "jarring_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Pasta sauce jars: {x.x:.2f}")
    print(f"BBQ sauce jars: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

