
from gurobipy import *

# Create a new model
m = Model("Sauce_Factory_Optimization")

# Define variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pasta_sauce_jars")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="barbecue_sauce_jars")

# Set the objective function: Maximize profit
m.setObjective(3*x + 5*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + 3*y <= 12500, "filling_machine_constraint")
m.addConstr(3*x + 4*y <= 20000, "jarring_machine_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of jars of pasta sauce: {x.x}")
    print(f"Number of jars of barbecue sauce: {y.x}")
    print(f"Maximum profit: ${3*x.x + 5*y.x:.2f}")
else:
    print("No optimal solution found")
