
import gurobi as gp

# Create a new model
model = gp.Model("sauce_production")

# Define variables
x = model.addVar(name="pasta_sauce", lb=0, vtype=gp.GRB.CONTINUOUS)
y = model.addVar(name="barbecue_sauce", lb=0, vtype=gp.GRB.CONTINUOUS)

# Objective function: Maximize 3x + 5y
model.setObjective(3*x + 5*y, sense=gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x + 3*y <= 12500, name="filling_machine_constraint")
model.addConstr(3*x + 4*y <= 20000, name="jarring_machine_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal production levels: Pasta Sauce = {x.varValue}, Barbecue Sauce = {y.varValue}")
    print(f"Maximum profit: ${3*x.varValue + 5*y.varValue:.2f}")
else:
    print("The model is infeasible or unbounded.")
