
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("e_commerce_optimization")

# Create decision variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="face_masks")
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="hand_sanitizers")

# Set objective function
m.setObjective(1*x + 1.5*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.5*x + 3*y <= 1000, "budget")
m.addConstr(x >= 80, "min_face_masks")
m.addConstr(x <= 500, "max_face_masks")
m.addConstr(y <= 0.5*x, "max_hand_sanitizers")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: {m.objVal}")
    print(f"Number of face masks: {x.x}")
    print(f"Number of hand sanitizers: {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

