
from gurobipy import *

# Create a new model
m = Model("Ecommerce_Optimization")

# Define decision variables
x = m.addVar(lb=80, ub=500, vtype=GRB.CONTINUOUS, name="face_masks")
y = m.addVar(vtype=GRB.CONTINUOUS, name="hand_sanitizers")

# Objective function: Maximize profit
m.setObjective(x + 1.5*y, GRB.MAXIMIZE)

# Budget constraint
m.addConstr(1.5*x + 3*y <= 1000, "budget_constraint")

# Constraint on hand sanitizers sold
m.addConstr(y <= 0.5*x, "hand_sanitizer_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Face Masks: {x.x}")
    print(f"Hand Sanitizers: {y.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
