
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define decision variables
    x = model.addVar(lb=0, name="face_masks")
    y = model.addVar(lb=0, name="hand_sanitizers")

    # Objective function: Maximize profit
    model.setObjective(1*x + 1.5*y, gurobi.GRB.MAXIMIZE)

    # Budget constraint
    model.addConstr(1.5*x + 3*y <= 1000, name="budget_constraint")

    # Face mask sales constraints
    model.addConstr(x >= 80, name="min_face_masks")
    model.addConstr(x <= 500, name="max_face_masks")

    # Hand sanitizer sales constraint
    model.addConstr(y <= 0.5*x, name="hand_sanitizer_constraint")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found: face masks = {x.varValue:.2f}, hand sanitizers = {y.varValue:.2f}")
        print(f"Maximum profit: {model.objVal:.2f}")
    else:
        print("No optimal solution found")

solve_optimization_problem()
