
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Surfboard_Skateboard_Production")

# Create decision variables
x = model.addVar(vtype=GRB.CONTINUOUS, name="surfboards")  # Surfboards
y = model.addVar(vtype=GRB.CONTINUOUS, name="skateboards") # Skateboards

# Set objective function
model.setObjective(70*x + 45*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(5*x + 4*y <= 700, "wood_constraint")
model.addConstr(3*x + 2*y <= 320, "paint_constraint")
model.addConstr(x >= 0, "surfboards_nonneg")
model.addConstr(y >= 0, "skateboards_nonneg")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of surfboards to produce: {x.x}")
    print(f"Number of skateboards to produce: {y.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

