
from gurobipy import *

# Create a new model
m = Model("Surfboard_Skateboard_Optimization")

# Define the decision variables
S = m.addVar(vtype=GRB.CONTINUOUS, name="Surfboards", lb=0)
K = m.addVar(vtype=GRB.CONTINUOUS, name="Skateboards", lb=0)

# Set the objective function
m.setObjective(70*S + 45*K, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*S + 4*K <= 700, "Wood_Constraint")
m.addConstr(3*S + 2*K <= 320, "Paint_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Surfboards to make: {S.x}")
    print(f"Skateboards to make: {K.x}")
    print(f"Maximum profit: ${70*S.x + 45*K.x:.2f}")
else:
    print("No optimal solution found")
