
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    S = model.addVar(lb=0, name="Surfboards")
    K = model.addVar(lb=0, name="Skateboards")

    # Define the objective function
    model.setObjective(70 * S + 45 * K, gurobi.GRB.MAXIMIZE)

    # Add the wood constraint
    model.addConstr(5 * S + 4 * K <= 700, name="Wood_Constraint")

    # Add the paint constraint
    model.addConstr(3 * S + 2 * K <= 320, name="Paint_Constraint")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found. Surfboards: {S.varValue}, Skateboards: {K.varValue}")
        print(f"Maximum profit: ${70 * S.varValue + 45 * K.varValue}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
