
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("LucasFarming")

# Create variables
x = m.addVar(lb=0, name="carrots") # Acres of carrots
y = m.addVar(lb=0, name="onions") # Acres of onions

# Set objective function
m.setObjective(75*x + 90*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 120, "land")
m.addConstr(1.5*x + 2*y <= 120, "tractor")
m.addConstr(2.5*x + 2*y <= 200, "handpicking")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x:.2f} acres of carrots")
    print(f"Plant {y.x:.2f} acres of onions")
    print(f"Maximum Profit: ${m.objVal:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

