
from gurobipy import *

# Create a new model
m = Model("Lucas_Farm")

# Define variables
x = m.addVar(lb=0, name="carrots")
y = m.addVar(lb=0, name="onions")

# Set the objective function to maximize profit
m.setObjective(75*x + 90*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 120, "land")
m.addConstr(1.5*x + 2*y <= 120, "tractor_time")
m.addConstr(2.5*x + 2*y <= 200, "hand_picking_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Carrots: {x.x} acres")
    print(f"Onions: {y.x} acres")
    print(f"Maximum Profit: ${m.objVal}")
else:
    print("No optimal solution found")
