
import gurobi as gp

# Create a new model
m = gp.Model("Lucas_Farm_Optimization")

# Define the variables
x = m.addVar(lb=0, name="acres_of_carrots")
y = m.addVar(lb=0, name="acres_of_onions")

# Objective function: Maximize profit
m.setObjective(75*x + 90*y, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(x + y <= 120, name="land_constraint")
m.addConstr(1.5*x + 2*y <= 120, name="tractor_time_constraint")
m.addConstr(2.5*x + 2*y <= 200, name="hand_picking_time_constraint")

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal acres of carrots: {x.varValue}")
    print(f"Optimal acres of onions: {y.varValue}")
    print(f"Maximal profit: ${m.objVal:.2f}")
else:
    print("The model is infeasible.")
