
import gurobipy as gp

# Create a new model
model = gp.Model("Emma's Fashion Shop")

# Create decision variables
x = model.addVar(vtype=gp.GRB.CONTINUOUS, name="dresses")  # Number of dresses
y = model.addVar(vtype=gp.GRB.CONTINUOUS, name="suits")  # Number of suits

# Set the objective function
model.setObjective(500*x + 800*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(2*x + y <= 30, "sewing_constraint")
model.addConstr(4*x + y <= 50, "embroidery_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of dresses to produce: {x.x}")
    print(f"Number of suits to produce: {y.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

