
from gurobipy import *

# Create a new model
m = Model("Emma_Clothing_Production")

# Define variables
D = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Dresses")
S = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Suits")

# Define constraints
m.addConstr(2*D + S <= 30, "Sewing_Machine_Constraint")
m.addConstr(4*D + S <= 50, "Embroidery_Machine_Constraint")

# Define objective function
m.setObjective(500*D + 800*S, GRB.MAXIMIZE)

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Produces {D.x} dresses")
    print(f"Produces {S.x} suits")
    print(f"Maximum profit: ${500*D.x + 800*S.x}")
else:
    print("No optimal solution found")

