
import gurobi as gp

# Create a new model
model = gp.Model("Production_Optimization")

# Define decision variables
D = model.addVar(lb=0, name="Dresses")
S = model.addVar(lb=0, name="Suits")

# Objective function: Maximize profit
model.setObjective(500*D + 800*S, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(2*D + S <= 30, name="Sewing_Constraint")
model.addConstr(4*D + S <= 50, name="Embroidery_Constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal production: Dresses = {D.varValue}, Suits = {S.varValue}")
    print(f"Max Profit: ${model.objVal:.2f}")
else:
    print("The model is infeasible")
