
import gurobipy as gp

# Create a new model
model = gp.Model("Fabric Packages")

# Create decision variables
x1 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x1")  # Package 1
x2 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x2")  # Package 2

# Set objective function
model.setObjective(50*x1 + 70*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(20*x1 + 40*x2 <= 10000, "Blue Fabric Constraint")
model.addConstr(30*x1 + 40*x2 <= 12000, "Red Fabric Constraint")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Package 1: {x1.x}")
    print(f"Number of Package 2: {x2.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

