
from gurobipy import *

# Create a new model
m = Model("Fabric_Sales")

# Define the decision variables
x = m.addVar(lb=0, name="Package_1")
y = m.addVar(lb=0, name="Package_2")

# Define the objective function
m.setObjective(50*x + 70*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x + 10*y <= 2500, name="Blue_Fabric_Constraint")
m.addConstr(3*x + 4*y <= 1200, name="Red_Fabric_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Package 1: {x.x}")
    print(f"Package 2: {y.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
