
import gurobi

def solve_fabric_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="Package_1", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="Package_2", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Maximize profit
    model.setObjective(50 * x1 + 70 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(20 * x1 + 40 * x2 <= 10000, name="blue_fabric_constraint")
    model.addConstr(30 * x1 + 40 * x2 <= 12000, name="red_fabric_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found. Package 1: {x1.varValue}, Package 2: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_fabric_problem()
