
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("costume_production")

    # Create variables
    x = m.addVar(vtype=GRB.INTEGER, name="superhero_costumes")
    y = m.addVar(vtype=GRB.INTEGER, name="fantasy_costumes")

    # Set objective function
    m.setObjective(24*x + 32*y, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(20*x + 15*y <= 3000, "time_constraint")
    m.addConstr(y >= 3*x, "demand_constraint")

    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print(f"Optimal Solution Found:")
        print(f"Number of superhero costumes: {x.x}")
        print(f"Number of fantasy costumes: {y.x}")
        print(f"Total profit: ${m.objVal}")
    elif m.status == GRB.INFEASIBLE:
        print("Model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')

