
from gurobipy import *

# Create a new model
m = Model("Costume_Optimization")

# Define variables
S = m.addVar(lb=0, vtype=GRB.INTEGER, name="Superhero_Costumes")
F = m.addVar(lb=0, vtype=GRB.INTEGER, name="Fantasy_Costumes")

# Objective function: Maximize total profit
m.setObjective(24*S + 32*F, GRB.MAXIMIZE)

# Constraints
m.addConstr(20*S + 15*F <= 3000, "Time_Constraint")
m.addConstr(F >= 3*S, "Market_Research_Constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Superhero Costumes: {S.x}")
    print(f"Fantasy Costumes: {F.x}")
    print(f"Total Profit: ${24*S.x + 32*F.x}")
else:
    print("No optimal solution found.")
