
import gurobi

def solve_party_supplies_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(name="superhero_costumes", lb=0, vtype=gurobi.GRB.INTEGER)
    y = model.addVar(name="fantasy_costumes", lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize 24x + 32y
    model.setObjective(24 * x + 32 * y, sense=gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(20 * x + 15 * y <= 3000, name="time_constraint")
    model.addConstr(y >= 3 * x, name="market_research_constraint")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found.")
        print(f"Superhero costumes: {x.varValue}")
        print(f"Fantasy costumes: {y.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_party_supplies_problem()
