
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("investment_problem")

# Create variables
x = m.addVar(lb=0, name="son_investment")
y = m.addVar(lb=0, name="friend_investment")

# Set objective function
m.setObjective(0.08 * x + 0.10 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 50000, "total_investment")
m.addConstr(x >= 3 * y, "son_ratio")
m.addConstr(x <= 40000, "son_limit")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Invest ${x.x:.2f} in son's company")
    print(f"Invest ${y.x:.2f} in friend's company")
    print(f"Total earnings: ${m.objVal:.2f}")
else:
    print("Infeasible or unbounded")

