
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Define the decision variables
x_s = m.addVar(lb=0, name="son_investment")
x_f = m.addVar(lb=0, name="friend_investment")

# Define the objective function: Maximize earnings
m.setObjective(0.08*x_s + 0.10*x_f, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x_s + x_f <= 50000, name="total_investment")
m.addConstr(x_s >= 3*x_f, name="son_to_friend_ratio")
m.addConstr(x_s <= 40000, name="max_son_investment")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f" Invest in son's company: ${x_s.x:.2f}")
    print(f" Invest in friend's company: ${x_f.x:.2f}")
    print(f" Total earnings: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
