
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="son's_company_investment", lb=0)
    y = model.addVar(name="friend's_company_investment", lb=0)

    # Objective function: Maximize earnings
    model.setObjective(0.08 * x + 0.10 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x + y <= 50000, name="total_investment_limit")
    model.addConstr(x >= 3 * y, name="minimum_investment_ratio")
    model.addConstr(x <= 40000, name="maximum_investment_in_son_company")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal investment in son's company: ${x.varValue:.2f}")
        print(f"Optimal investment in friend's company: ${y.varValue:.2f}")
        print(f"Maximized earnings: ${0.08 * x.varValue + 0.10 * y.varValue:.2f}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    solve_investment_problem()
