
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Electronics_Profit")

# Create decision variables
c = m.addVar(lb=0, vtype=GRB.INTEGER, name="controllers")
s = m.addVar(lb=0, vtype=GRB.INTEGER, name="speakers")

# Set objective function
m.setObjective(70*c + 20*s, GRB.MAXIMIZE)

# Add constraints
m.addConstr(150*c + 100*s <= 50000, "budget")
m.addConstr(c >= 15, "min_controllers")
m.addConstr(c <= 60, "max_controllers")
m.addConstr(s <= 4*c, "speaker_limit")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Profit: ${m.objVal}")
    print(f"Number of Controllers to Sell: {c.x}")
    print(f"Number of Speakers to Sell: {s.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

