
from gurobipy import *

# Create a model
m = Model("Iota_Game_Profit_Optimization")

# Decision variables
C = m.addVar(vtype=GRB.INTEGER, name="controllers", lb=15, ub=60)  # Number of controllers sold
S = m.addVar(vtype=GRB.INTEGER, name="speakers")  # Number of speakers sold

# Objective function: Maximize profit
m.setObjective(70*C + 20*S, GRB.MAXIMIZE)

# Constraints
m.addConstr(150*C + 100*S <= 50000, name="budget_constraint")
m.addConstr(S <= 4*C, name="speakers_vs_controllers")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Sell {C.x} controllers and {S.x} speakers.")
    print(f"Maximum profit: ${70*C.x + 20*S.x}")
else:
    print("No optimal solution found")

