
import gurobi

def maximize_profit():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    C = model.addVar(lb=15, ub=60, name="controllers")  # 15 <= C <= 60
    S = model.addVar(name="speakers")  # S >= 0, implicitly

    # Objective function: Maximize profit
    model.setObjective(70*C + 20*S, gurobi.GRB.MAXIMIZE)

    # Cost constraint: 150C + 100S <= 50000
    model.addConstr(150*C + 100*S <= 50000, name="cost_constraint")

    # Speaker sales constraint: S <= 4C
    model.addConstr(S <= 4*C, name="speaker_sales_constraint")

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Controllers = {C.varValue}, Speakers = {S.varValue}")
        print(f"Max Profit: ${model.objVal}")
    else:
        print("No optimal solution found")

maximize_profit()
