
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("ferry_tickets")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.INTEGER, name="vehicle_tickets")
y = model.addVar(lb=0, vtype=GRB.INTEGER, name="passenger_tickets")

# Set objective function
model.setObjective(50*x + 50*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(x + y <= 100, "total_tickets")
model.addConstr(x >= 10, "min_vehicle_tickets")
model.addConstr(y >= 5*x, "passenger_ratio")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of vehicle tickets: {x.x}")
    print(f"Number of passenger tickets: {y.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status {model.status}")

