
from gurobipy import *

# Create a new model
m = Model("Ferry_Ticket_Sales")

# Define the variables
V = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Vehicle_Tickets")
P = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Passenger_Tickets")

# Define the objective function: Maximize profit
m.setObjective(50*V + 50*P, GRB.MAXIMIZE)

# Add constraints
m.addConstr(V + P <= 100, "Total_Tickets_Constraint")
m.addConstr(V >= 10, "Minimum_Vehicle_Tickets_Constraint")
m.addConstr(P >= 5*V, "Passenger_to_Vehicle_Ratio_Constraint")

# Optimize the model
m.optimize()

# Print out the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {V.varName} = {V.x}, {P.varName} = {P.x}")
    print(f"Maximum Profit: ${50*V.x + 50*P.x}")
else:
    print("No optimal solution found")
