
import gurobi

def ferry_ticket_optimization():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    v = model.addVar(lb=0, name="vehicle_tickets")
    p = model.addVar(lb=0, name="passenger_tickets")

    # Objective function: Maximize profit
    model.setObjective(gurobi.quicksum([50 * v, 50 * p]), gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(v + p <= 100, name="total_tickets")
    model.addConstr(v >= 10, name="min_vehicle_tickets")
    model.addConstr(p >= 5 * v, name="passenger_vs_vehicle_tickets")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution:")
        print(f"Vehicle Tickets: {v.varValue}")
        print(f"Passenger Tickets: {p.varValue}")
        print(f"Max Profit: ${50 * v.varValue + 50 * p.varValue}")
    else:
        print("No optimal solution found.")

# Run the optimization
ferry_ticket_optimization()
