
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("fish_transport")

# Create variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="freight_train_trips") # Integer number of train trips
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="cargo_ship_trips")    # Integer number of ship trips

# Set objective function
m.setObjective(2000*x + 7000*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(100*x + 180*y <= 1500, "budget_constraint")
m.addConstr(x < y, "train_trip_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal number of fish transported: {m.objVal}")
    print(f"Number of freight train trips: {x.x}")
    print(f"Number of cargo ship trips: {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

