
from gurobipy import *

# Create a model
m = Model("Fish_Transportation")

# Define decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="freight_trains")
y = m.addVar(vtype=GRB.CONTINUOUS, name="cargo_ships")

# Objective function: Maximize the total number of fish transported
m.setObjective(2000*x + 7000*y, GRB.MAXIMIZE)

# Constraint 1: Budget constraint
m.addConstr(100*x + 180*y <= 1500, "budget_constraint")

# Constraint 2: Number of freight train trips is less than cargo ship trips
m.addConstr(x <= y - 0.001, "trip_constraint")  # Using a small epsilon value

# Solve the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Maximum fish transported: {m.objVal}")
    print(f"Number of freight train trips: {x.x}")
    print(f"Number of cargo ship trips: {y.x}")
else:
    print("Model is infeasible")
