
import gurobi

def theta_fishing_transport():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=0, name="freight_train_trips")  # Number of freight train trips
    y = model.addVar(lb=0, name="cargo_ship_trips")   # Number of cargo ship trips

    # Objective function: Maximize the number of fish transported
    model.setObjective(2000*x + 7000*y, gurobi.GRB.MAXIMIZE)

    # Budget constraint
    model.addConstr(100*x + 180*y <= 1500, name="budget_constraint")

    # Trip constraint: Number of freight train trips < number of cargo ship trips
    model.addConstr(x <= y - 1e-6, name="trip_constraint")  # Using a small tolerance for strict inequality

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: x = {x.varValue}, y = {y.varValue}")
        print(f"Maximum fish transported: {2000*x.varValue + 7000*y.varValue}")
    else:
        print("The model is infeasible or unbounded.")

theta_fishing_transport()
