
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("YoungBucksProduction")

# Create decision variables
x_alpha = model.addVar(lb=0, name="x_alpha")
x_beta = model.addVar(lb=0, name="x_beta")

# Set objective function
model.setObjective(40 * x_alpha + 100 * x_beta, GRB.MINIMIZE)

# Add constraints
model.addConstr(3 * x_alpha + 5 * x_beta >= 100, "CementProduction")
model.addConstr(2 * x_alpha + 4 * x_beta >= 80, "StuccoProduction")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Cost: ${model.objVal}")
    print(f"Alpha Operating Hours: {x_alpha.x}")
    print(f"Beta Operating Hours: {x_beta.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

