
from gurobipy import *

# Create a new model
m = Model("Young_Bucks_Production")

# Define the decision variables
x = m.addVar(lb=0, name="hours_alpha")  # Hours plant Alpha is run
y = m.addVar(lb=0, name="hours_beta")   # Hours plant Beta is run

# Objective function: minimize total cost
m.setObjective(40*x + 100*y, GRB.MINIMIZE)

# Constraints
# At least 100 tons of cement must be produced daily
m.addConstr(3*x + 5*y >= 100, name="cement_production")

# At least 80 tons of stucco must be produced daily
m.addConstr(2*x + 4*y >= 80, name="stucco_production")

# Optimize the model
m.optimize()

# Print out the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Run plant Alpha for {x.x} hours")
    print(f"Run plant Beta for {y.x} hours")
    print(f"Total cost: ${40*x.x + 100*y.x}")
else:
    print("No optimal solution found")

