
import gurobi

def solve_production_planning():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x_alpha = model.addVar(lb=0, name="x_alpha")  # Hours for plant Alpha
    x_beta = model.addVar(lb=0, name="x_beta")   # Hours for plant Beta

    # Objective function: Minimize cost
    model.setObjective(40 * x_alpha + 100 * x_beta, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(3 * x_alpha + 5 * x_beta >= 100, name="cement_demand")
    model.addConstr(2 * x_alpha + 4 * x_beta >= 80, name="stucco_demand")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Run plant Alpha for {x_alpha.varValue} hours")
        print(f"Run plant Beta for {x_beta.varValue} hours")
        print(f"Total cost: ${model.objVal:.2f}")
    else:
        print("No optimal solution found")

solve_production_planning()
