
import gurobipy as gp

# Create a new model
m = gp.Model("X-Luxury_Cloth")

# Create variables
x = m.addVar(lb=0, name="coats")  # Number of coats
y = m.addVar(lb=0, name="skirts") # Number of skirts

# Set objective function
m.setObjective(12*x + 16*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.5*x + 3*y <= 45, "designing_time")
m.addConstr(2.5*x + 3.5*y <= 70, "printing_time")


# Optimize model
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Coats (x): {x.x}")
    print(f"  Skirts (y): {y.x}")
    print(f"  Optimal profit: {m.objVal}")
    print(f"Optimal Ratio: {x.x/y.x:.2f}") # Calculate and print the ratio
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

